/* ============ */
/* plangap.c	*/
/* ============ */
#include <defcodes.h>
#include <mconf.h>
#include <miscdefs.h>
#include <gapdefs.h>
#include <gapprobs.c>

/* ==================================================== */
/* PlanCupn - Prints Sample Sizes Required for Gap Test	*/
/* ==================================================== */
#define	MAX_GAPS	100
void
main()
{
    AbortGracefully();			/* Make ^C Reasonable */

    while (main)
    {
	char	*LeftLbl;
	int	k, m;
	int	CellExpect, MaxGapCt, MinGapCt, WhereMax, WhereMin;
	double  SumCellExpect;
	double	HiLimit, LoLimit, GapProbs[MAX_GAPS+1], TotalProb;

	for (;;)
	{
	    GetDbl("Enter Lower Limit of Gap [>=0,<1]: ",
		&LoLimit);
	    if (LoLimit >= 0 && LoLimit < 1)
	    {
		break;
	    }
	    fprintf(stderr, "Incorrect Entry\n");
	}

	for (;;)
	{
	    char    Prompt[64];
	    sprintf(Prompt, "Enter Upper Limit of Gap [> %g,<=1]: ",
		LoLimit);

	    GetDbl(Prompt, &HiLimit);

	    if (HiLimit > LoLimit && HiLimit <= 1)
	    {
		break;
	    }
	    fprintf(stderr, "Incorrect Entry\n");
	}
	MinGapCt = -1; MaxGapCt = -1; WhereMin = -1; WhereMax = -1;

	for (k = 0; k < MAX_GAP_LEN; ++k)
	{
	    CalcGapProbs(k+1, LoLimit, HiLimit, GapProbs);

	    {
		double	MaxPerGap = -1;
		for (m = k; m >= 0; --m)

		{
		    MaxPerGap =
			__max(MaxPerGap, MIN_CELL_XPCT/GapProbs[m]);
		}
		if (MaxPerGap > (double)MAX_NUM_GAPS)
		{
		    break;
		}
		else
		{
		    MinGapCt = __max((int)MaxPerGap, MinGapCt);
		    if (MinGapCt == (int)MaxPerGap)
		    {
			WhereMin = k;
		    }
		}
		MaxPerGap = -1;
		for (m = k; m >= 0; --m)
		{
		    MaxPerGap =
			__max(MaxPerGap, MAX_CELL_XPCT/GapProbs[m]);
		}
		if (MaxPerGap > (double)MAX_NUM_GAPS)
		{
		    break;
		}
		if (MaxPerGap > (double)MAX_NUM_GAPS)
		{
		    break;
		}
		else
		{
		    MaxGapCt = __max((int)MaxPerGap, MaxGapCt);
		    if (MaxGapCt == (int)MaxPerGap)
		    {
			WhereMax = k;
		    }
		}
	    }
	}
	printf("Gap Boundaries: (%g, %g)\n", LoLimit, HiLimit);
	printf("K = %d, MAX_GAP_LEN = %d\n", k, MAX_GAP_LEN);
	printf("MinGapCt = %d (@ k=%d), MaxGapCt = %d (@ k=%d)\n",
		MinGapCt, WhereMin, MaxGapCt, WhereMax);
	SumCellExpect = TotalProb = 0;
	CalcGapProbs(WhereMax+1, LoLimit, HiLimit, GapProbs);
	printf("\nProbabilities for Maximum Cell Expectation (%d)\n",
		MAX_CELL_XPCT);
	printf("Gap Len    Probability           Cell Expectation\n");

	for (m = 0; m <= WhereMax; ++m)
	{
	    double  CellExpect = MaxGapCt * GapProbs[m];
	    printf("%4d%23.11e%14.f\n",
		m, GapProbs[m], CellExpect);
	    TotalProb += GapProbs[m];
	    SumCellExpect += CellExpect;
	}
	printf("Totals:%20.11e%14.f\n", TotalProb, SumCellExpect);

	SumCellExpect = TotalProb = 0;
	CalcGapProbs(WhereMin+1, LoLimit, HiLimit, GapProbs);
	printf("\nProbabilities for Minimum Cell Expectation (%d)\n",
		MIN_CELL_XPCT);
	printf("Gap Len    Probability           Cell Expectation\n");
	for (m = 0; m <= WhereMin; ++m)
	{
	    double  CellExpect = MinGapCt * GapProbs[m];
	    printf("%4d%23.11e%14.f\n",
		m, GapProbs[m], CellExpect);
	    TotalProb += GapProbs[m];
	    SumCellExpect += CellExpect;
	}
	printf("Totals:%20.11e%14.f\n", TotalProb, SumCellExpect);
exit(1);
	for (;;)
	{
	    GetInt("Enter Maximum Gap Length [> 0]: ",
		&MaxGapCt);
	    if (MaxGapCt > 0)
	    {
		break;
	    }
	    fprintf(stderr, "Incorrect Entry\n");
	}

	CalcGapProbs(MaxGapCt+1, LoLimit, HiLimit, GapProbs);

	for (;;)
	{
      	    GetInt("Enter Minimum Expectation For Each Gap:\t",
		&CellExpect);

	    if (CellExpect >= 1)
	    {
		break;
	    }
	    fprintf(stderr, "Incorrect Entry\n");
	}

	TotalProb = 0;
	LeftLbl = ">= ";

	printf("Gap Len  Gap Probability     Cell Expectation"
	       "   # Variates Required\n");
	for (k = MaxGapCt; k >= 0; --k)
	{
	    double  DevReqd = ceil(0.5 + CellExpect/GapProbs[k]);
	    printf("%3s%3d  %.11e%10s", LeftLbl, k, GapProbs[k], "");
	    printf("%5d%15s%5.f\n", CellExpect, "", DevReqd);
	    TotalProb += GapProbs[k];
	    LeftLbl = "";
	}

	printf("%26.11e  (Total)\n", TotalProb);
    }
}
